import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

public class testGUI extends MIDlet 
       implements CommandListener {
  // Dclare le gestionnaire d'affichage
  Display display = null;
  // Dclare le menu comprenant des lments
  List myMenu = null;
  // Dclare la liste de choix
  List myList = null;
  // Dclare la zone de texte
  TextBox myTextbox = null;
  // Dclare et cre le ticker
  Ticker myTicker = new Ticker ("Test du GUI");
  // Dclare et cre l'alerte
  final Alert myAlert = new Alert ("Alerte sonore");
  // Dclare et cre la date
  DateField myDate = new DateField ("Date d'ajourd'hui : ", DateField.DATE);
  // Dclare et cre le formulaire
  Form myForm = new Form ("Formulaire");
  // Dclare et cre la jauge
  Gauge myGauge = new Gauge("Jauge", true, 10, 0);
  // Dclare et cre le champ de texte
  TextField myTextfield = new TextField("Champ de texte", "", 50, 0);
  // Dclare et cre les commandes retour, menu et sortie
  static final Command cmdRetour = new Command ("Retour", Command.BACK, 0);
  static final Command cmdMenu = new Command ("Menu", Command.SCREEN, 1);
  static final Command cmdSortie = new Command ("Sortie", Command.STOP, 2);

  /**
   *  Constructeur
  **/
  public testGUI() {
  }

  /**
   *  Lance le MIDlet.
   *  Cre une liste d'lments et la commande Sortie.
  **/
  public void startApp() 
         throws MIDletStateChangeException {
    display = Display.getDisplay (this);
    // Cre le menu
    myMenu = new List ("Test GUI", Choice.IMPLICIT);
    // Ajoute les options
    myMenu.append ("Test Fielbox", null);
    myMenu.append ("Test List", null);
    myMenu.append ("Test Alert", null);
    myMenu.append ("Test Date", null);
    myMenu.append ("Test Form", null);
    // Ajoute la commande sortie
    myMenu.addCommand (cmdSortie);
    // Met en place le listener
    myMenu.setCommandListener (this);
    // Cre le ticker
    myMenu.setTicker (myTicker);
    mainMenu();
  }

  /**
   *  Suspend le MIDlet
  **/
  public void pauseApp() {
    // Remet  zro toutes les variables
    display = null;
    myList = null;
    myMenu = null;
    myTicker = null;
    myForm = null;
    myTextbox = null;
    myGauge = null;
    myTextfield = null;
  }

  /**
   *  Libre les ressources
  **/
  public void destroyApp (boolean unconditional) {
    notifyDestroyed();
  }

  /**
   *  Menu principal
  **/
  void mainMenu() {
    display.setCurrent(myMenu);
  }

  /**
   *  Test du composant TextBox
  **/
  public void testTextBox() {
    // Affiche une zone de texte de largeur 5 avec le libell
    // "Entrez un message"
    myTextbox = new TextBox ("Entrez un message :", "", 5, TextField.ANY);
    // Cre un ticker
    myTextbox.setTicker (new Ticker ("testTextBox"));
    // Ajoute une commande de retour
    myTextbox.addCommand (cmdRetour);
    // Met en place le listener
    myTextbox.setCommandListener (this);
    myTextbox.setString ("");
    display.setCurrent (myTextbox);
  }

  /**
   *  Test du composant List
  **/
  public void testList() {
    // Cre une liste
    myList = new List ("Faites votre choix", myList.MULTIPLE);
    // Cre un ticker
    myList.setTicker (new Ticker ("testList"));
    // Ajoute une commande de retour
    myList.addCommand (cmdRetour);
    // Met en place le listener
    myList.setCommandListener (this);
    // Ajoute les lments de la liste
    myList.append ("Option 1", null);
    myList.append ("Option 2", null);
    myList.append ("Option 3", null);
    display.setCurrent (myList);
  }

  /**
   *  Test du composant Alert
  **/
  public void testAlert() {
    // Cre une alerte d'erreur
    myAlert.setType (AlertType.ERROR);
    myAlert.setString ("*** ERREUR ***");
    display.setCurrent (myAlert);
  }

  /**
   *  Test du composant DateField
  **/
  public void testDate() {
    // Lit l'heure courante
    java.util.Date now = new java.util.Date();
    myDate.setDate (now);
    // Cre un formulaire
    Form myForm = new Form ("Date d'aujourd'hui");
    myForm.append (myDate);
    // Ajoute une commande de retour
    myForm.addCommand (cmdRetour);
    // Met en place le listener
    myForm.setCommandListener (this);
    display.setCurrent (myForm);
  }

  /**
   *  Test du composant Form
  **/
  public void testForm() {
    // Cre une jauge et un champ de texte
    myForm.append (myGauge);
    myForm.append (myTextfield);
    // Ajoute une commande de retour
    myForm.addCommand (cmdRetour);
    // Met en place le listener
    myForm.setCommandListener (this);
    display.setCurrent (myForm);
  }

  /**
   *  Gestion des vnements
  **/  
  public void commandAction (Command cmdSelected, Displayable d) {
    // Si la commande Sortie est active, on quitte le MIDlet.
    String label = cmdSelected.getLabel();
    if (label.equals ("Sortie")) {
      destroyApp (true);
    } else if (label.equals ("Retour")) {
      // Si la commande Retour est active, on retourne au menu.
       // Retourne au menu
       mainMenu();
    } else {
      // Dans les autres cas, il s'agit forcment de la slection d'un lment
      // de la liste. On lit la position de l'lment slectionn dans la liste
      // et on appelle la mthode correspondante.
      List down = (List) display.getCurrent();
      switch (down.getSelectedIndex()) {
        case 0: 
          testTextBox();
          break;
        case 1:
          testList();
          break;
        case 2:
          testAlert();
          break;
        case 3:
          testDate();
          break;
        case 4:
          testForm();
          break;
      }
    }
  }
}
